/*
 * Decompiled with CFR 0.152.
 */
package filenet.pe.peorb.test;

import com.filenet.api.core.Connection;
import com.filenet.api.core.Factory;
import com.filenet.api.util.UserContext;
import filenet.pe.ceutils.ConnectionPoint;
import filenet.pe.ceutils.ConnectionPoints;
import filenet.pe.peorb.test.APIClientTest;
import filenet.vw.api.VWAttachment;
import filenet.vw.api.VWCompoundStepDefinition;
import filenet.vw.api.VWCreateLiveWOResult;
import filenet.vw.api.VWMapDefinition;
import filenet.vw.api.VWMapNode;
import filenet.vw.api.VWParameterDefinition;
import filenet.vw.api.VWPartnerLinkDefinition;
import filenet.vw.api.VWQueue;
import filenet.vw.api.VWQueueElement;
import filenet.vw.api.VWQueueQuery;
import filenet.vw.api.VWRoster;
import filenet.vw.api.VWRosterQuery;
import filenet.vw.api.VWSession;
import filenet.vw.api.VWStepDefinition;
import filenet.vw.api.VWStepElement;
import filenet.vw.api.VWSystemAdministration;
import filenet.vw.api.VWSystemConfiguration;
import filenet.vw.api.VWTransferResult;
import filenet.vw.api.VWUserInfo;
import filenet.vw.api.VWWorkflowCollectionDefinition;
import filenet.vw.api.VWWorkflowDefinition;
import filenet.vw.api.VWWorkflowSignature;
import filenet.vw.api.VWXMLUtil;
import filenet.vw.base.logging.Logger;
import filenet.vw.toolkit.utils.VWCommandLineArgs;
import java.util.ArrayList;
import java.util.Date;
import java.util.List;
import javax.security.auth.Subject;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
enum TestCodeEnum {
    ListCP("listcp"){

        protected boolean logonRequired() {
            return false;
        }

        public void execute(String myId, VWCommandLineArgs c, VWSession ses) throws Exception {
            String pePasswd;
            String peUser;
            String ceURI = c.getParameter("ceURI");
            ConnectionPoint[] cps = ConnectionPoints.GetConnectionPoints(ceURI, peUser = c.getParameter("username"), pePasswd = c.getParameter("password"));
            if (cps != null && cps.length > 0) {
                for (ConnectionPoint cp : cps) {
                    System.out.println(cp);
                }
            }
        }

        public void getMyParams(StringBuffer buf) {
        }
    }
    ,
    LogonTests("logonTests"){

        public void execute(String myId, VWCommandLineArgs c, VWSession ses) throws Exception {
            String ceURI = c.getParameter("ceURI");
            String cp = c.getParameter("cp");
            String peUser = c.getParameter("username");
            String pePasswd = c.getParameter("password");
            String ceUser = c.getParameter(this.rpc + ".ceuser", peUser);
            String cePw = c.getParameter(this.rpc + ".cepw", pePasswd);
            Subject ceSubject = UserContext.createSubject((Connection)Factory.Connection.getConnection((String)ceURI), (String)ceUser, (String)cePw, (String)"FileNetP8WSI");
            UserContext uc = UserContext.get();
            uc.pushSubject(ceSubject);
            VWSession session = new VWSession();
            session.setBootstrapCEURI(ceURI);
            session.logon(peUser, pePasswd, cp);
            String qname = "Conductor";
            VWQueue queue = session.getQueue(qname);
            System.out.printf("Successfully retrieved %s using PE user %s:%s while connected to CE as %s:%s\n", qname, peUser, pePasswd, ceUser, cePw);
            uc.popSubject();
        }

        public void getMyParams(StringBuffer buf) {
            this.writeOneParam(buf, "ceuser");
            this.writeOneParam(buf, "cepw");
        }
    }
    ,
    InitRegion("initializeRegion"){

        public void execute(String myId, VWCommandLineArgs c, VWSession ses) throws Exception {
            System.out.println("**** About to get the system administration object ...");
            VWSystemAdministration adm = ses.fetchSystemAdministration();
            System.out.println("**** About to Initialize the region ...");
            adm.initializeRegion();
            System.out.println("**** Region Initialized...");
        }

        public void getMyParams(StringBuffer buf) {
        }
    }
    ,
    SetUpRegion("setupRegion"){

        public void execute(String myId, VWCommandLineArgs c, VWSession ses) throws Exception {
            VWSystemConfiguration sc = ses.fetchSystemConfiguration();
            boolean bCommit = false;
            bCommit = APIClientTest.createQueue(sc, "Q1");
            bCommit |= APIClientTest.createQueue(sc, "Q2");
            bCommit |= APIClientTest.createRoster(sc, "R1");
            if (bCommit |= APIClientTest.createRoster(sc, "R2")) {
                System.out.println("Transferring the new queues..");
                sc.commit();
                System.out.println("Finished transferring...");
            }
            APIClientTest.verifySystemConfig(ses);
            APIClientTest.tranferCannedWfl(ses);
        }

        public void getMyParams(StringBuffer buf) {
        }
    }
    ,
    GeneralTests("generalTests"){

        public void execute(String myId, VWCommandLineArgs c, VWSession ses) throws Exception {
            APIClientTest.msg(myId, "**** fetchWorkClassNames...");
            String[] wcNames = ses.fetchWorkClassNames(true);
            if (wcNames != null) {
                APIClientTest.msg(myId, "**** fetchWorkClassNames returned =" + Logger.asString(wcNames));
                if (wcNames.length > 0) {
                    APIClientTest.msg(myId, "**** fetchWorkflowSignature for " + wcNames[0]);
                    VWWorkflowSignature sig = ses.fetchWorkflowSignature(wcNames[0]);
                    APIClientTest.msg(myId, "**** fetchWorkflowSignature for " + wcNames[0] + " returns " + sig.getName());
                }
            }
            APIClientTest.msg(myId, "**** fetchSystemAdministration...");
            VWSystemAdministration adminInfo = ses.fetchSystemAdministration();
            APIClientTest.msg(myId, "**** successfully fetchSystemAdministration...");
            APIClientTest.msg(myId, "*** fetchCurrentUserInfo... ");
            VWUserInfo userInfo = ses.fetchCurrentUserInfo();
            APIClientTest.msg(myId, "*** successfully fetchCurrentUserInfo ... ");
            String username = userInfo.getName();
            VWUserInfo user = adminInfo.fetchUserInfo(username);
            String emailAddr = user.getEMailAddress();
            APIClientTest.msg(myId, "**** successfully fetchUserInfo(" + username + ").emailAddress=" + emailAddr);
            APIClientTest.msg(myId, "**** fetchSystemConfiguration...");
            VWSystemConfiguration configData = ses.fetchSystemConfiguration();
            APIClientTest.msg(myId, "**** successfully fetched system configuration.");
            int myQueueFlags = 21;
            APIClientTest.msg(myId, "**** fetchQueueNames...");
            String[] queues = ses.fetchQueueNames(myQueueFlags);
            if (queues != null) {
                APIClientTest.msg(myId, "**** fetchQueueNames returned =" + Logger.asString(queues));
            }
            APIClientTest.msg(myId, "**** recoverUser for " + username);
            ses.recoverUser(username, null);
            APIClientTest.msg(myId, "*** DONE GeneralTests.. ");
        }

        public void getMyParams(StringBuffer buf) {
        }
    }
    ,
    WCLaunchParams("wcLaunchParams"){

        public void execute(String myId, VWCommandLineArgs c, VWSession ses) throws Exception {
            APIClientTest.msg(myId, "**** wcLaunchParams ...");
            int wsId = c.getIntParameter("wsId", -1);
            String[] wcNames = ses.fetchWorkClassNames(true);
            String opName = "createLiveWO";
            if (wcNames != null) {
                for (String wc : wcNames) {
                    int nFields;
                    System.out.println("#--------------------------");
                    System.out.printf("%s.wc=%s\n", "createLiveWO", wc);
                    VWWorkflowDefinition wfdef = ses.fetchWorkflowDefinition(wsId, wc, false);
                    VWStepDefinition launchStep = wfdef.getLaunchStep();
                    VWParameterDefinition[] params = launchStep.getParameterDefinitions();
                    int n = nFields = params == null ? 0 : params.length;
                    if (params == null) continue;
                    System.out.printf("%s.nFields=%d\n", "createLiveWO", nFields);
                    int i = 0;
                    for (VWParameterDefinition param : params) {
                        String fld = "createLiveWO.field" + i++;
                        System.out.printf("%s.name=%s\n", fld, param.getName());
                        System.out.printf("%s.fieldType=%d\n", fld, param.getDataType());
                        System.out.printf("%s.isArray=%s\n", fld, Boolean.toString(param.getIsArray()));
                        String value = null;
                        switch (param.getDataType()) {
                            case 4: {
                                value = "true/false";
                                break;
                            }
                            case 32: {
                                value = new VWAttachment().toString();
                                break;
                            }
                            case 8: {
                                value = "float..";
                                break;
                            }
                            case 1: {
                                value = "integer";
                                break;
                            }
                            case 2: {
                                value = "string";
                                break;
                            }
                            case 16: {
                                value = "dateTime";
                                break;
                            }
                            case 64: {
                                value = "participant";
                                break;
                            }
                            default: {
                                value = "unknownType";
                            }
                        }
                        System.out.printf("%s.value=%s\n", fld, value);
                        System.out.println();
                    }
                }
            }
            APIClientTest.msg(myId, "*** DONE wcLaunchParams.. ");
        }

        public void getMyParams(StringBuffer buf) {
            this.writeOneParam(buf, "wsId=# -1 for latest");
            buf.append("# use this to generate the createLiveWO parameter.\n)").append("# fieldType=1:Integer,2:String,4:Boolean,8:Double/Float,16:Date,32:,64:,128:String-type like Attachment,Participant,XML");
        }
    }
    ,
    CreateLiveWorkObject("createLiveWO"){

        protected void getMyParams(StringBuffer buf) {
            this.writeOneParam(buf, "wc=xxx");
            this.writeOneParam(buf, "nToCreate=# default is 5");
            this.writeOneParam(buf, "nFields=#");
            this.writeOneParam(buf, "field#.name=xxx");
            this.writeOneParam(buf, "field#.value=xxx");
            this.writeOneParam(buf, "isArray=true/false");
            this.writeOneParam(buf, "field#.fieldType=1:Integer,2:String,4:Boolean,8:Double/Float,16:Date,32:,64:,128:String-type like Attachment,Participant,XML");
        }

        protected void execute(String myId, VWCommandLineArgs c, VWSession ses) throws Exception {
            String wc = c.getParameter(this.rpc + ".wc");
            int nToCreate = c.getIntParameter(this.rpc + ".nToCreate", 5);
            int nFields = c.getIntParameter(this.rpc + ".nFields", 0);
            String[] fieldNames = new String[nFields];
            Object[] fieldValues = new Object[nFields];
            block9: for (int i = 0; i < nFields; ++i) {
                String fieldName;
                String suffix = this.rpc + ".field" + Integer.toString(i);
                fieldNames[i] = fieldName = c.getParameter(suffix + ".name");
                String fieldValueStr = c.getParameter(suffix + ".value");
                int fieldType = c.getIntParameter(suffix + ".fieldType", 0);
                boolean fieldIsArray = Boolean.valueOf(c.getParameter(suffix + ".isArray", "false"));
                switch (fieldType) {
                    case 8: {
                        if (fieldIsArray) continue block9;
                        fieldValues[i] = new Double(fieldValueStr);
                        continue block9;
                    }
                    case 1: {
                        if (fieldIsArray) continue block9;
                        fieldValues[i] = new Integer(fieldValueStr);
                        continue block9;
                    }
                    case 2: 
                    case 32: 
                    case 64: 
                    case 128: {
                        if (fieldIsArray) continue block9;
                        fieldValues[i] = fieldValueStr;
                        continue block9;
                    }
                    case 16: {
                        if (fieldIsArray) continue block9;
                        fieldValues[i] = new Date();
                        continue block9;
                    }
                    case 4: {
                        if (fieldIsArray) continue block9;
                        fieldValues[i] = new Boolean(fieldValueStr);
                        continue block9;
                    }
                    default: {
                        throw new Exception("invalid field type");
                    }
                }
            }
            try {
                APIClientTest.msg(myId, "calling CreateLiveWO, wc=" + wc);
                VWCreateLiveWOResult[] res = ses.createLiveWorkObject(fieldNames, fieldValues, wc, nToCreate);
                APIClientTest.msg(myId, "returns " + Logger.asString(res));
            }
            catch (Exception e) {
                e.printStackTrace();
            }
        }
    }
    ,
    CreateWorkflow("createWorkflow"){

        public void getMyParams(StringBuffer buf) {
            this.writeOneParam(buf, "wc=xxx");
        }

        public void execute(String myId, VWCommandLineArgs c, VWSession ses) throws Exception {
            String wcClass = c.getParameter(this.rpc + ".wc");
            if (wcClass == null) {
                return;
            }
            APIClientTest.msg(myId, "Starting..");
            VWStepElement vwStepElement = ses.createWorkflow(wcClass);
            vwStepElement.setParameterValue("F_Subject", this.rpc + " ApiClientTest " + new Date().toString(), true);
            if (APIClientTest.verbose) {
                APIClientTest.msg(myId, VWXMLUtil.makeXMLBlock(vwStepElement));
            }
            APIClientTest.msg(myId, ".. dispatching ..");
            vwStepElement.doDispatch();
            APIClientTest.msg(myId, "Finished dispatching..");
        }
    }
    ,
    IsMemberOfGroup("isMemberOfGroup"){

        public void getMyParams(StringBuffer buf) {
            this.writeOneParam(buf, "group=xxx");
        }

        public void execute(String myId, VWCommandLineArgs c, VWSession ses) throws Exception {
            String group = c.getParameter(this.rpc + ".group", "PEAdministrators");
            APIClientTest.msg(myId, " check for " + group + "?...");
            boolean b = ses.isMemberOfGroup(group);
            APIClientTest.msg(myId, c.getParameter("username", "qdang") + " is " + (b ? "" : "not") + " in " + group);
        }
    }
    ,
    QueueOp("queueOp"){

        public void execute(String myId, VWCommandLineArgs c, VWSession ses) throws Exception {
            boolean fetchStepElement;
            String queueName = c.getParameter(this.rpc + ".queueName", "Inbox");
            int queueSize = c.getIntParameter(this.rpc + ".queueSize", 100);
            boolean viewOnly = c.isPresent(this.rpc + ".viewOnly");
            boolean showXML = c.isPresent(this.rpc + ".showXML");
            boolean bl = fetchStepElement = c.isPresent(this.rpc + ".fetchStepElement") || !viewOnly;
            if (queueSize > 200) {
                queueSize = 200;
                APIClientTest.msg(myId, "Reseting queueSize for processing to " + queueSize);
            }
            VWQueue q = ses.getQueue(queueName);
            int option = 610;
            if (!viewOnly) {
                option += 16;
            }
            q.setBufferSize(queueSize);
            VWQueueQuery queue_query = q.createQuery(null, null, null, option, null, null, fetchStepElement ? 5 : 3);
            int nItems = queue_query.fetchCount();
            queueSize = Math.min(queueSize, nItems);
            APIClientTest.msg(myId, queueName + " has " + nItems + " items.");
            if (queueSize > 0) {
                APIClientTest.msg(myId, queueSize + " items....");
            }
            int i = 0;
            while (i++ < queueSize && queue_query.hasNext()) {
                try {
                    if (fetchStepElement) {
                        VWStepElement vwStepElement = (VWStepElement)queue_query.next();
                        if (APIClientTest.verbose) {
                            APIClientTest.msg(myId, "--------- " + queueName + "[" + ++i + "]:" + vwStepElement.getWorkObjectNumber());
                            if (showXML) {
                                APIClientTest.msg(myId, VWXMLUtil.makeXMLBlock(vwStepElement));
                            }
                        }
                        if (viewOnly) continue;
                        APIClientTest.msg(myId, "Dispatching step element...");
                        vwStepElement.doDispatch();
                        APIClientTest.msg(myId, "Finished dispatching step element...");
                        continue;
                    }
                    VWQueueElement vwQueueElement = (VWQueueElement)queue_query.next();
                    if (!APIClientTest.verbose) continue;
                    APIClientTest.msg(myId, "--------- " + queueName + "[" + ++i + "]:" + vwQueueElement.getWorkObjectNumber());
                    if (!showXML) continue;
                    APIClientTest.msg(myId, VWXMLUtil.makeXMLBlock(vwQueueElement));
                }
                catch (Exception e) {
                    e.printStackTrace();
                }
            }
        }

        public void getMyParams(StringBuffer buf) {
            this.writeOneParam(buf, "queueName=xxx");
            this.writeOneParam(buf, "queueSize=#");
            this.writeOneParam(buf, "fetchStepElement");
            this.writeOneParam(buf, "viewOnly");
            this.writeOneParam(buf, "showXML");
        }
    }
    ,
    MyWorkflows("myWorkflows"){

        public void execute(String myId, VWCommandLineArgs c, VWSession ses) throws Exception {
            String userName = c.getParameter("username");
            int userId = ses.convertUserNameToId(userName);
            String[] rosterNames = ses.fetchRosterNames(false);
            int nRosters = rosterNames == null ? 0 : rosterNames.length;
            for (int i = 0; i < nRosters; ++i) {
                String rosterName = rosterNames[i];
                APIClientTest.msg(myId, "--------- " + rosterName + "[" + userName + "]:");
                VWRoster r = ses.getRoster(rosterName);
                VWRosterQuery roster_query = r.createQuery(null, null, null, 0, "F_Originator=" + userId + " and F_TrackerStatus=0", null, 5);
                while (roster_query.hasNext()) {
                    try {
                        VWStepElement vwStepElement = (VWStepElement)roster_query.next();
                        String sSubject = vwStepElement.getSubject();
                        APIClientTest.msg(myId, "VWStepElement.getSubject = " + sSubject);
                        String m_subject = (String)vwStepElement.getParameterValue("F_Subject");
                        APIClientTest.msg(myId, "VWStepElement.getParameterValue(\"F_Subject\")=" + m_subject);
                        if (!APIClientTest.verbose) continue;
                        APIClientTest.msg(myId, VWXMLUtil.makeXMLBlock(vwStepElement));
                    }
                    catch (Exception e) {
                        e.printStackTrace();
                    }
                }
            }
        }

        public void getMyParams(StringBuffer buf) {
        }
    }
    ,
    PEWSGetQueueElements("pewsGetQueueElements"){

        public void execute(String myId, VWCommandLineArgs c, VWSession ses) throws Exception {
            String queueName = c.getParameter(this.rpc + ".queueName");
            int nToReturn = c.getIntParameter(this.rpc + ".nToReturn", 100);
            int QUERY_BUFFER_SIZE = 100;
            VWQueue aVWQueue = ses.getQueue(queueName);
            VWQueueQuery aVWQueueQuery = aVWQueue.createQuery(null, null, null, 3072, null, null, 3);
            if (aVWQueueQuery != null) {
                int nEle = 0;
                int nLeft = nToReturn;
                boolean bLastChunk = false;
                if (nToReturn < QUERY_BUFFER_SIZE) {
                    aVWQueueQuery.setBufferSize(nToReturn);
                    bLastChunk = true;
                } else {
                    aVWQueueQuery.setBufferSize(QUERY_BUFFER_SIZE);
                }
                while (nLeft > 0 && aVWQueueQuery.hasNext() && nEle < nToReturn) {
                    if (!bLastChunk && nLeft < QUERY_BUFFER_SIZE) {
                        aVWQueueQuery.setBufferSize(nLeft);
                        bLastChunk = true;
                    }
                    VWQueueElement aVWQueueElement = (VWQueueElement)aVWQueueQuery.next();
                    if (APIClientTest.verbose) {
                        StringBuffer buf = new StringBuffer();
                        aVWQueueElement.toXML(buf);
                        APIClientTest.msg(myId, "aVWQueueElement=" + buf);
                        continue;
                    }
                    System.out.println(myId + ":" + aVWQueueElement.getWorkObjectNumber());
                }
            }
        }

        public void getMyParams(StringBuffer buf) {
            this.writeOneParam(buf, "queueName=xxx");
            this.writeOneParam(buf, "nToReturn=#");
        }
    }
    ,
    FetchWorkClassXML("fetchWorkClassXML"){

        public void execute(String myId, VWCommandLineArgs c, VWSession ses) throws Exception {
            APIClientTest.getWorkClass(myId, ses, c.getIntParameter(this.rpc + ".wsId", -1), c.getParameter(this.rpc + ".wc"));
        }

        public void getMyParams(StringBuffer buf) {
            this.writeOneParam(buf, "wsId=# (-1 for latest)");
            this.writeOneParam(buf, "wc=xxx");
        }
    }
    ,
    FetchAllWorkClassesXML("fetchAllWorkClassesXML"){

        public void execute(String myId, VWCommandLineArgs c, VWSession ses) throws Exception {
            String[] wcNames = ses.fetchWorkClassNames(true);
            if (wcNames == null) {
                return;
            }
            for (String wcName : wcNames) {
                APIClientTest.getWorkClass(myId, ses, c.getIntParameter(this.rpc + ".wsId", -1), wcName);
            }
        }

        public void getMyParams(StringBuffer buf) {
            this.writeOneParam(buf, "wsId=# (-1 for latest)");
        }
    }
    ,
    Transfer("transfer"){

        public void execute(String myId, VWCommandLineArgs c, VWSession ses) throws Exception {
            String fileName = c.getParameter(this.rpc + ".filename");
            if (fileName == null) {
                System.err.println("No " + this.rpc + ".filename parameter!");
                return;
            }
            String wc = c.getParameter(this.rpc + ".wc");
            VWWorkflowCollectionDefinition wflColl = VWWorkflowCollectionDefinition.readFromFile(fileName);
            VWTransferResult res = null;
            res = wc == null ? ses.transferWFCollection(wflColl, "DOCKEY?", false, true) : ses.transfer(wflColl.getWorkflow(wc), "DOCKEY?", false, true);
            if (res.success()) {
                APIClientTest.msg(myId, "Successfully transferred workflow.." + res.getVersion());
            } else {
                String[] errs = res.getErrors();
                System.err.println("Failed to transfer workflow: " + Logger.asString(errs));
            }
        }

        public void getMyParams(StringBuffer buf) {
            this.writeOneParam(buf, "filename=XPDL filename");
            this.writeOneParam(buf, "wc=omitted for all OR a workclass name within the collection");
        }
    }
    ,
    PLInspect("PLInspect"){

        protected boolean logonRequired() {
            return false;
        }

        public void execute(String myId, VWCommandLineArgs c, VWSession ses) throws Exception {
            String fileName = c.getParameter(this.rpc + ".filename");
            if (fileName == null) {
                System.err.println("No " + this.rpc + ".filename parameter!");
                return;
            }
            VWWorkflowCollectionDefinition wflColl = null;
            VWWorkflowDefinition[] wflDefs = null;
            wflColl = VWWorkflowCollectionDefinition.readFromFile(fileName);
            wflDefs = wflColl.getWorkflows();
            if (wflDefs != null) {
                for (VWWorkflowDefinition wfl : wflDefs) {
                    String wflName = wfl.getName();
                    APIClientTest.msg(myId, "Checking " + wflName);
                    APIClientTest.inspectPL(wfl);
                    String s = fileName + "." + wflName + ".PEP";
                    wfl.writeToFile(s);
                    System.out.println("Write to " + s);
                }
            }
        }

        public void getMyParams(StringBuffer buf) {
            this.writeOneParam(buf, "filename=XPDL  or PEPfilename");
        }
    }
    ,
    ListPL("listPL"){

        public void execute(String myId, VWCommandLineArgs c, VWSession ses) throws Exception {
            APIClientTest.msg(myId, "**** list partner links...");
            long startTime = System.currentTimeMillis();
            String[] wcNames = ses.fetchWorkClassNames(true);
            ArrayList<String> partnerlinkRefs = new ArrayList<String>(wcNames == null ? 0 : wcNames.length);
            if (wcNames != null) {
                for (String wc : wcNames) {
                    VWWorkflowDefinition wfDef = ses.fetchWorkflowDefinition(-1, wc);
                    try {
                        VWPartnerLinkDefinition[] pls = wfDef.getPartnerLinks();
                        if (pls == null) continue;
                        for (VWPartnerLinkDefinition pl : pls) {
                            String s = pl.getPartnerLinkRef();
                            if (s == null || s.trim().length() <= 0) continue;
                            partnerlinkRefs.add(wc + "," + s.trim());
                        }
                    }
                    catch (Exception e) {
                        e.printStackTrace();
                    }
                }
            }
            long elapsed = System.currentTimeMillis() - startTime;
            System.out.println("Getting partnerlink refs took:" + elapsed + "ms.");
            for (String s : partnerlinkRefs) {
                System.out.println(s);
            }
        }

        public void getMyParams(StringBuffer buf) {
            this.writeOneParam(buf, "filename=XPDL  or PEPfilename");
        }
    }
    ,
    XPDLTests("xpdlTests"){

        protected boolean logonRequired() {
            return false;
        }

        public void execute(String myId, VWCommandLineArgs c, VWSession ses) throws Exception {
            int nWSDLRefs;
            String fileName = c.getParameter(this.rpc + ".filename");
            String partnerlink = c.getParameter(this.rpc + ".partnerlinks");
            String[] partnerlinks = partnerlink == null ? null : partnerlink.split(",");
            int nPLs = partnerlinks == null ? 0 : partnerlinks.length;
            String solution = c.getParameter(this.rpc + ".solution");
            String caseName = c.getParameter(this.rpc + ".case");
            String activity = c.getParameter(this.rpc + ".activity");
            String wsdlRef = c.getParameter(this.rpc + ".wsdlRefs");
            String[] wsdlRefs = wsdlRef == null ? null : wsdlRef.split(",");
            int n = nWSDLRefs = wsdlRefs == null ? 0 : wsdlRefs.length;
            assert (nPLs == nWSDLRefs);
            if (fileName == null) {
                System.err.println("No " + this.rpc + ".filename parameter!");
                return;
            }
            VWWorkflowCollectionDefinition wflColl = null;
            VWWorkflowDefinition[] wflDefs = null;
            wflColl = VWWorkflowCollectionDefinition.readFromFile(fileName);
            wflDefs = wflColl.getWorkflows();
            if (wflDefs != null) {
                for (VWWorkflowDefinition wfl : wflDefs) {
                    VWMapDefinition mainMap;
                    VWMapNode[] steps;
                    String wflName = wfl.getName();
                    APIClientTest.msg(myId, "Checking " + wflName);
                    APIClientTest.inspectPL(wfl);
                    for (int j = 0; j < nPLs; ++j) {
                        try {
                            VWPartnerLinkDefinition pl = wfl.getPartnerLink(partnerlinks[j]);
                            if (pl == null) {
                                System.err.println("Can't find " + partnerlinks[j]);
                                continue;
                            }
                            String plRef = solution + "##" + caseName + "##" + activity + "##" + partnerlinks[j];
                            pl.setPartnerLinkRef(plRef);
                            pl.setWSDLRef(wsdlRefs[j]);
                            APIClientTest.msg(myId, "Setting PartnerLink=" + partnerlinks[j] + ", ref=" + pl.getPartnerLinkRef() + ", wsdlRef=" + pl.getWSDLRef() + ", endpoint=" + pl.getPartnerEndPoint());
                            continue;
                        }
                        catch (Throwable t) {
                            t.printStackTrace();
                        }
                    }
                    APIClientTest.msg(myId, "Inspecting " + wfl.getName());
                    List<String> authors = wfl.getOtherAuthorTools();
                    for (String a : authors) {
                        APIClientTest.msg(myId, a);
                    }
                    wfl.addAdditionalAuthorTool("QUYNHWASHERE1");
                    String s = "QUYNHWASHERE2";
                    wfl.addAdditionalAuthorTool(s);
                    wfl.addAdditionalAuthorTool(s);
                    authors = wfl.getOtherAuthorTools();
                    for (String a : authors) {
                        APIClientTest.msg(myId, a);
                    }
                    if (authors.contains(s)) {
                        System.err.println("Should not have the extra author tool" + s);
                    }
                    int nSteps = (steps = (mainMap = wfl.getMainMap()).getSteps()) == null ? 0 : steps.length;
                    for (int i = 0; i < nSteps; ++i) {
                        String curAuthorTool = steps[i].getAuthorTool();
                        APIClientTest.msg(myId, curAuthorTool);
                        if (!(steps[i] instanceof VWCompoundStepDefinition) || curAuthorTool != null) continue;
                        steps[i].setAuthorTool("MYWID");
                    }
                }
            }
            String newFileName = fileName + ".new";
            if (wflColl.getSource() == 1) {
                wflColl.getMainWorkflow().writeToFile(newFileName);
            } else {
                wflColl.writeToFile(newFileName);
            }
            APIClientTest.msg(myId, "Written to " + newFileName);
        }

        public void getMyParams(StringBuffer buf) {
            this.writeOneParam(buf, "filename=<XPDLorPEPfileName>");
            this.writeOneParam(buf, "partnerlinks=<partnerlinkname>,..");
            this.writeOneParam(buf, "solution=<solution>");
            this.writeOneParam(buf, "case=<case>");
            this.writeOneParam(buf, "activity=<activity>");
            this.writeOneParam(buf, "wsdlRefs=CEOS:{VersionSeries},...");
        }
    }
    ,
    ParseXPDL("parseXPDL"){

        protected boolean logonRequired() {
            return false;
        }

        public void execute(String myId, VWCommandLineArgs c, VWSession ses) throws Exception {
            String fileName = c.getParameter(this.rpc + ".filename");
            if (fileName == null) {
                System.err.println("No " + this.rpc + ".filename parameter!");
                return;
            }
            VWWorkflowCollectionDefinition wflColl = null;
            VWWorkflowDefinition[] wflDefs = null;
            wflColl = VWWorkflowCollectionDefinition.readFromFile(fileName);
            wflDefs = wflColl.getWorkflows();
            ArrayList<String> wcNames = new ArrayList<String>(wflDefs == null ? 0 : wflDefs.length);
            if (wflDefs != null) {
                for (VWWorkflowDefinition wfl : wflDefs) {
                    String wflName = wfl.getName();
                    wcNames.add(wflName);
                    VWMapDefinition mainMap = wfl.getMainMap();
                    VWMapNode[] steps = mainMap.getSteps();
                    int nSteps = steps == null ? 0 : steps.length;
                    for (int i = 0; i < nSteps; ++i) {
                        String curAuthorTool = steps[i].getAuthorTool();
                        APIClientTest.msg(myId, curAuthorTool);
                    }
                }
            }
            if (c.isPresent(this.rpc + ".clean")) {
                for (String s : wcNames) {
                    wflColl.removeWorkflow(s);
                }
                String newFileName = fileName + ".new";
                if (wflColl.getSource() == 1) {
                    wflColl.getMainWorkflow().writeToFile(newFileName);
                } else {
                    wflColl.writeToFile(newFileName);
                }
                APIClientTest.msg(myId, "Written to " + newFileName);
            }
        }

        public void getMyParams(StringBuffer buf) {
            this.writeOneParam(buf, "filename=<XPDLorPEPfileName>");
            this.writeOneParam(buf, "clean={true,false}");
        }
    };

    protected String rpc;

    private TestCodeEnum(String rpc) {
        this.rpc = rpc;
    }

    protected abstract void getMyParams(StringBuffer var1);

    protected abstract void execute(String var1, VWCommandLineArgs var2, VWSession var3) throws Exception;

    protected long run(String myId, VWCommandLineArgs c, VWSession ses) {
        long startTime = System.currentTimeMillis();
        try {
            this.execute(myId, c, ses);
        }
        catch (Throwable t) {
            t.printStackTrace();
        }
        return System.currentTimeMillis() - startTime;
    }

    protected boolean logonRequired() {
        return true;
    }

    protected void writeOneParam(StringBuffer buf, String paramName) {
        buf.append("#").append(this.rpc).append(".").append(paramName).append("\n");
    }

    protected static TestCodeEnum getTest(String rpc) throws Exception {
        TestCodeEnum[] tests;
        for (TestCodeEnum test : tests = TestCodeEnum.values()) {
            if (!test.rpc.equals(rpc)) continue;
            return test;
        }
        throw new Exception("Invalid test: " + rpc);
    }

    protected static void getTestCodeParams(StringBuffer buf) {
        TestCodeEnum[] tests;
        for (TestCodeEnum test : tests = TestCodeEnum.values()) {
            buf.append("\n##---------- ").append(test.rpc).append(" parameters --------\n#rpc=").append(test.rpc).append("\n");
            test.getMyParams(buf);
        }
    }
}

